'use strict'

var container = document.getElementById( 'container' );

// scene settings
var scene = new THREE.Scene();
var camera = new THREE.PerspectiveCamera( 60, window.innerWidth / window.innerHeight, 1, 10000 );
camera.position.set( 500, 0, 0 );

// render settings
var renderer = new THREE.WebGLRenderer( { antialias: true, alpha: true });
renderer.setSize( window.innerWidth, window.innerHeight );
renderer.setPixelRatio( window.devicePixelRatio );
container.appendChild( renderer.domElement );

var controls = new THREE.OrbitControls( camera, renderer.domElement );
var clock = new THREE.Clock();

var colors = [
	0xed6a5a,
	0xf4f1bb,
	0x9bc1bc,
	0x5ca4a9,
	0xe6ebe0,
	0xf0b67f,
	0xfe5f55,
	0xd6d1b1,
	0xc7efcf,
	0xeef5db,
	0x50514f,
	0xf25f5c,
	0xffe066,
	0x247ba0,
	0x70c1b3
];

var resolution = new THREE.Vector2( window.innerWidth, window.innerHeight );

init()
render();

var material = new MeshLineMaterial( {
	map: THREE.ImageUtils.loadTexture( 'assets/stroke.png' ),
	useMap: false,
	color: new THREE.Color( colors[ 3 ] ),
	opacity: .5,
	resolution: resolution,
	sizeAttenuation: false,
	lineWidth: 10,
	near: camera.near,
	far: camera.far,
	depthWrite: false,
	depthTest: false,
	transparent: true
});

function init() {

	readModel().then( collectPoints );

}

function readModel() {

	return new Promise( function( resolve, reject ) {

		var loader = new THREE.OBJLoader();
		loader.load( 'assets/bubbles02.obj', function( res ) {
			resolve( res );
		} )

	});

}

// actual curve generation
function collectPoints( source ) {

	console.log( source );
	var g = source.children[ 0 ].geometry;
	//var g = new THREE.
	THREE.GeometryUtils.center( g );
	var scaleMatrix = new THREE.Matrix4();
	scaleMatrix.makeScale( 1000, 1000, 1000 );
	g.applyMatrix( scaleMatrix );

	var o = new THREE.Mesh( g, new THREE.MeshNormalMaterial() );
	//scene.add( o );

	var raycaster = new THREE.Raycaster();

	var points = [];

	var y = 0;
	var a = 0;
	var r = 10000;
	var origin = new THREE.Vector3();
	var direction = new THREE.Vector3();

	// Curve projection
	var simplexNoise = new SimplexNoise;

	// noise seems between -1.0 and 1.0
	var noiseVal = [];

	var noiseScale = 1;

	// step of the ray
	var step = 1;

	for( var j = 0; j < 10000; j++ ) {
		var pa;
		var py;
		// trying to make spherical raycasting...
		origin.set( r * Math.cos( a ) * Math.abs(Math.cos(y)), r * Math.sin(y), r * Math.sin( a ) * Math.abs(Math.cos(y)));

		noiseVal[j] = simplexNoise.noise(origin.x / noiseScale, origin.y / noiseScale, origin.z / noiseScale) * 0.1;


		direction.set( -origin.x, -origin.y, -origin.z );
		direction = direction.normalize();
		raycaster.set( origin, direction );

		var i = raycaster.intersectObject( o, true );

		if( i.length ) {
			points.push( i[ 0 ].point.x, i[ 0 ].point.y, i[ 0 ].point.z );
		}

		//pass current value to "previous value"
		pa = a;
		py = y;

		var noiseDir;
		if (THREE.Math.randInt(0, 1) == 0) {
			noiseDir = -1;
		} else {
			noiseDir = 1;
		}

		//set angle and height for the next loop
		a = pa + noiseVal[j] * noiseDir * step;
		y = py + noiseVal[j] * step;

	}

	var l = new MeshLine();
	// "p" as the argument of function below seems the radius of the line...
	l.setGeometry( points, function( p ) { return p = 0.5 } );
	var line = new THREE.Mesh( l.geometry, material );
	scene.add( line );

	document.querySelector( '#title p' ).style.display = 'none';

}

onWindowResize();

function onWindowResize() {

	var w = container.clientWidth;
	var h = container.clientHeight;

	camera.aspect = w / h;
	camera.updateProjectionMatrix();

	renderer.setSize( w, h );

	resolution.set( w, h );

}

window.addEventListener( 'resize', onWindowResize );

function render() {

	requestAnimationFrame( render );
	controls.update();

	renderer.render( scene, camera );

}
